<?php
session_start();
require_once 'config.php';

try {
    $pdo = new PDO('mysql:host='.DB_HOST.';dbname='.DB_NAME.';charset=utf8mb4', DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->exec("SET NAMES utf8mb4");
} catch(PDOException $e) {
    die("<div class='alert alert-danger'>خطا در اتصال به پایگاه داده: " . $e->getMessage() . "</div>");
}

// تنظیم ID آزمون و ID کاربر
$exam_id = isset($_GET['exam_id']) ? intval($_GET['exam_id']) : 0;
$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;
$token = isset($_GET['token']) ? $_GET['token'] : '';

// بررسی اعتبار توکن
$isValidToken = false;
$isDemo = isset($_GET['demo']) && $_GET['demo'] == 1;

// اگر حالت دمو باشد (برای نمایش به ادمین‌ها)
if ($isDemo && $exam_id > 0) {
    $isValidToken = true;
    
    // دریافت اطلاعات آزمون
    $stmt = $pdo->prepare("SELECT * FROM exams WHERE id = :id");
    $stmt->execute([':id' => $exam_id]);
    $exam = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$exam) {
        $error_message = "آزمون مورد نظر یافت نشد.";
    }
} 
// حالت عادی - بررسی توکن
else if ($exam_id && $user_id && $token) {
    $stmt = $pdo->prepare("SELECT telegram_id FROM users WHERE id = :user_id");
    $stmt->execute([':user_id' => $user_id]);
    $telegram_id = $stmt->fetchColumn();
    
    if ($telegram_id) {
        // ساخت توکن با ترکیب ID کاربر، ID آزمون و کلید مخفی
        $expected_token = md5($user_id . $exam_id . 'SECRET_KEY_CHANGE_THIS');
        if ($token === $expected_token) {
            $isValidToken = true;
        }
    }
}

// بررسی اتمام آزمون
if (isset($_POST['finish_exam']) && $isValidToken) {
    // ثبت نمره و اتمام آزمون
    $score = 0;
    
    if (isset($_POST['answers']) && is_array($_POST['answers'])) {
        foreach ($_POST['answers'] as $question_id => $answer) {
            // ثبت پاسخ کاربر
            if (is_array($answer)) { // چند گزینه‌ای
                foreach ($answer as $option_id) {
                    $stmt = $pdo->prepare("
                        INSERT INTO user_answers (question_id, user_id, option_id)
                        VALUES (:question_id, :user_id, :option_id)
                    ");
                    $stmt->execute([
                        ':question_id' => $question_id,
                        ':user_id' => $user_id,
                        ':option_id' => $option_id
                    ]);
                }
            } else if (is_string($answer) && trim($answer) !== '') { // تشریحی
                $stmt = $pdo->prepare("
                    INSERT INTO user_answers (question_id, user_id, text_answer)
                    VALUES (:question_id, :user_id, :text_answer)
                ");
                $stmt->execute([
                    ':question_id' => $question_id,
                    ':user_id' => $user_id,
                    ':text_answer' => $answer
                ]);
            }
            
            // محاسبه نمره برای سوالات چندگزینه‌ای
            if (is_array($answer)) {
                $stmt = $pdo->prepare("
                    SELECT q.score
                    FROM questions q
                    WHERE q.id = :question_id
                ");
                $stmt->execute([':question_id' => $question_id]);
                $question_score = $stmt->fetchColumn();
                
                $stmt = $pdo->prepare("
                    SELECT COUNT(*) as total_options,
                           SUM(CASE WHEN is_correct = 1 THEN 1 ELSE 0 END) as correct_options
                    FROM options
                    WHERE question_id = :question_id
                ");
                $stmt->execute([':question_id' => $question_id]);
                $options_info = $stmt->fetch(PDO::FETCH_ASSOC);
                
                // بررسی صحت پاسخ‌ها
                $stmt = $pdo->prepare("
                    SELECT COUNT(*) as correct_answered
                    FROM options
                    WHERE question_id = :question_id
                      AND id IN (" . implode(',', array_map('intval', $answer)) . ")
                      AND is_correct = 1
                ");
                $stmt->execute([':question_id' => $question_id]);
                $correct_answered = $stmt->fetchColumn();
                
                // اگر همه گزینه‌های صحیح انتخاب شده باشند
                if ($correct_answered == $options_info['correct_options'] && count($answer) == $options_info['correct_options']) {
                    $score += $question_score;
                }
            }
        }
    }
    
    // ثبت نتیجه آزمون
    $stmt = $pdo->prepare("
        INSERT INTO results (exam_id, user_id, score)
        VALUES (:exam_id, :user_id, :score)
        ON DUPLICATE KEY UPDATE score = :score
    ");
    $stmt->execute([
        ':exam_id' => $exam_id,
        ':user_id' => $user_id,
        ':score' => $score
    ]);
    
    // ثبت لاگ اتمام آزمون
    $stmt = $pdo->prepare("
        INSERT INTO exam_logs (exam_id, user_id, action, details)
        VALUES (:exam_id, :user_id, 'finish', :details)
    ");
    $stmt->execute([
        ':exam_id' => $exam_id,
        ':user_id' => $user_id,
        ':details' => json_encode(['score' => $score])
    ]);
    
    // نمایش صفحه نتیجه
    $_SESSION['exam_completed'] = true;
    $_SESSION['exam_score'] = $score;
    header("Location: exam.php?exam_id=$exam_id&user_id=$user_id&token=$token&completed=1");
    exit;
}

// اگر کاربر مجاز نباشد یا آزمون نامعتبر باشد
if (!$isValidToken || $exam_id <= 0) {
    $error_message = "خطا: دسترسی غیرمجاز یا آزمون نامعتبر";
}

// دریافت اطلاعات آزمون
$exam = null;
if ($isValidToken) {
    $stmt = $pdo->prepare("SELECT * FROM exams WHERE id = :id AND start_time <= NOW() AND end_time >= NOW()");
    $stmt->execute([':id' => $exam_id]);
    $exam = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // بررسی اینکه آیا کاربر قبلاً آزمون را تکمیل کرده است
    $stmt = $pdo->prepare("SELECT * FROM results WHERE exam_id = :exam_id AND user_id = :user_id");
    $stmt->execute([':exam_id' => $exam_id, ':user_id' => $user_id]);
    $existing_result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // اگر قبلاً آزمون تکمیل شده و صفحه نتیجه نمایش داده می‌شود
    if (($existing_result || isset($_SESSION['exam_completed'])) && isset($_GET['completed'])) {
        $score = isset($_SESSION['exam_score']) ? $_SESSION['exam_score'] : $existing_result['score'];
        $completion_message = true;
    }
}

// دریافت سوالات آزمون
$questions = [];
if ($isValidToken && $exam) {
    $stmt = $pdo->prepare("SELECT * FROM questions WHERE exam_id = :exam_id ORDER BY id");
    $stmt->execute([':exam_id' => $exam_id]);
    $questions = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // دریافت گزینه‌های هر سوال
    foreach ($questions as &$question) {
        $stmt = $pdo->prepare("SELECT * FROM options WHERE question_id = :question_id ORDER BY id");
        $stmt->execute([':question_id' => $question['id']]);
        $question['options'] = $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title><?= isset($exam['title']) ? $exam['title'] : 'سیستم آزمون آنلاین' ?></title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Vazirmatn', sans-serif;
            background: #f5f8fa;
            margin: 0;
            padding: 0;
            color: #333;
            text-align: right;
        }
        .header {
            background: #007bff;
            color: white;
            padding: 15px 0;
            margin-bottom: 30px;
        }
        .exam-container {
            background: white;
            border-radius: 8px;
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
            padding: 25px;
            margin-bottom: 30px;
        }
        .exam-header {
            border-bottom: 1px solid #eee;
            margin-bottom: 20px;
            padding-bottom: 15px;
        }
        .question {
            margin-bottom: 25px;
            padding-bottom: 20px;
            border-bottom: 1px solid #eee;
        }
        .question-text {
            font-weight: 500;
            margin-bottom: 15px;
        }
        .question-number {
            background: #007bff;
            color: white;
            display: inline-block;
            width: 30px;
            height: 30px;
            text-align: center;
            line-height: 30px;
            border-radius: 50%;
            margin-left: 10px;
        }
        .options label {
            display: block;
            padding: 10px 15px;
            border: 1px solid #ddd;
            border-radius: 5px;
            margin-bottom: 8px;
            cursor: pointer;
            transition: all 0.2s;
        }
        .options label:hover {
            background: #f8f9fa;
        }
        .options input[type="checkbox"]:checked + label,
        .options input[type="radio"]:checked + label {
            background: #e3f2fd;
            border-color: #007bff;
        }
        .options input[type="checkbox"],
        .options input[type="radio"] {
            display: none;
        }
        .text-answer {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            min-height: 100px;
        }
        .submit-btn {
            background: #007bff;
            color: white;
            border: none;
            padding: 10px 25px;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            transition: all 0.2s;
        }
        .submit-btn:hover {
            background: #0069d9;
        }
        .timer {
            background: #f8f9fa;
            padding: 10px 15px;
            border-radius: 5px;
            border: 1px solid #ddd;
            text-align: center;
            font-size: 18px;
            margin-bottom: 20px;
        }
        .result-card {
            text-align: center;
            padding: 30px;
        }
        .score {
            font-size: 72px;
            color: #007bff;
            margin: 20px 0;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="container">
            <h1><?= isset($exam['title']) ? $exam['title'] : 'سیستم آزمون آنلاین' ?></h1>
        </div>
    </div>
    
    <div class="container">
        <?php if (isset($error_message)): ?>
            <div class="alert alert-danger"><?= $error_message ?></div>
        <?php elseif (isset($completion_message)): ?>
            <div class="exam-container">
                <div class="result-card">
                    <h2>آزمون با موفقیت به پایان رسید</h2>
                    <p class="score"><?= $score ?></p>
                    <p>نمره شما از این آزمون</p>
                    <p>نتیجه آزمون شما در سیستم ثبت شد.</p>
                    <a href="https://t.me/<?= BOT_TOKEN ?>" class="btn btn-primary mt-4">بازگشت به ربات</a>
                </div>
            </div>
        <?php elseif ($exam): ?>
            <div class="exam-container">
                <div class="exam-header">
                    <div class="row">
                        <div class="col-md-8">
                            <h2><?= $exam['title'] ?></h2>
                            <?php if (!empty($exam['description'])): ?>
                                <p><?= $exam['description'] ?></p>
                            <?php endif; ?>
                        </div>
                        <div class="col-md-4">
                            <div class="timer" id="exam-timer">
                                زمان باقیمانده: <span id="timer-value">--:--:--</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <?php if (!empty($questions)): ?>
                    <form method="post" id="exam-form">
                        <?php foreach($questions as $index => $question): ?>
                            <div class="question">
                                <div class="question-text">
                                    <span class="question-number"><?= $index + 1 ?></span>
                                    <?php
    // نمایش سطح دشواری
    if (!empty($question['difficulty_level'])) {
        $diffLabel = '';
        switch($question['difficulty_level']) {
            case 'easy': $diffLabel = 'آسان'; break;
            case 'medium': $diffLabel = 'متوسط'; break;
            case 'hard': $diffLabel = 'سخت'; break;
        }
        echo '<span class="badge badge-warning ml-2">سطح: ' . $diffLabel . '</span>';
    }
    // نمایش تصویر سوال
    if (!empty($question['image_url'])) {
        echo '<br><img src="' . htmlspecialchars($question['image_url']) . '" alt="تصویر سوال" class="img-fluid mb-2" style="max-width:300px;max-height:200px;">';
    }
?>
<?= $question['question_text'] ?>
<?php if ($question['score'] > 0): ?>
    <span class="badge badge-info"><?= $question['score'] ?> نمره</span>
<?php endif; ?>
                                </div>
                                
                                <?php if ($question['question_type'] === 'multiple'): ?>
                                    <div class="options">
                                        <?php foreach($question['options'] as $option): ?>
                                            <?php 
                                                $input_type = count(array_filter($question['options'], function($o) {
                                                    return $o['is_correct'] == 1;
                                                })) > 1 ? 'checkbox' : 'radio';
                                                $input_id = "option_{$option['id']}";
                                            ?>
                                            <div>
                                                <input type="<?= $input_type ?>" name="answers[<?= $question['id'] ?>]<?= $input_type === 'checkbox' ? '[]' : '' ?>" 
                                                    id="<?= $input_id ?>" value="<?= $option['id'] ?>">
                                                <label for="<?= $input_id ?>"><?= $option['option_text'] ?></label>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                <?php elseif ($question['question_type'] === 'descriptive'): ?>
                                    <textarea name="answers[<?= $question['id'] ?>]" class="text-answer" 
                                        placeholder="پاسخ خود را اینجا بنویسید..."></textarea>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                        
                        <div class="text-center mt-4">
                            <input type="hidden" name="finish_exam" value="1">
                            <button type="submit" class="submit-btn">پایان و ثبت آزمون</button>
                        </div>
                    </form>
                <?php else: ?>
                    <div class="alert alert-info">هیچ سوالی برای این آزمون تعریف نشده است.</div>
                <?php endif; ?>
            </div>
            
            <script>
                // تنظیم تایمر آزمون
                function setupExamTimer() {
                    const endTime = new Date("<?= $exam['end_time'] ?>").getTime();
                    
                    function updateTimer() {
                        const now = new Date().getTime();
                        const distance = endTime - now;
                        
                        if (distance < 0) {
                            clearInterval(timerInterval);
                            document.getElementById('timer-value').textContent = "پایان زمان!";
                            document.getElementById('exam-form').submit();
                            return;
                        }
                        
                        const hours = Math.floor(distance / (1000 * 60 * 60));
                        const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                        const seconds = Math.floor((distance % (1000 * 60)) / 1000);
                        
                        document.getElementById('timer-value').textContent = 
                            (hours < 10 ? '0' + hours : hours) + ":" + 
                            (minutes < 10 ? '0' + minutes : minutes) + ":" + 
                            (seconds < 10 ? '0' + seconds : seconds);
                    }
                    
                    updateTimer();
                    const timerInterval = setInterval(updateTimer, 1000);
                }
                
                document.addEventListener('DOMContentLoaded', setupExamTimer);
            </script>
        <?php endif; ?>
    </div>
</body>
</html> 