-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: localhost:3306
-- Generation Time: Feb 28, 2025 at 08:58 PM
-- Server version: 10.11.10-MariaDB-cll-lve
-- PHP Version: 8.3.14

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `senioram_ShopBot`
--

-- ایجاد دیتابیس اگر وجود نداشته باشد
CREATE DATABASE IF NOT EXISTS `senioram_ShopBot` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

-- استفاده از دیتابیس
USE `senioram_ShopBot`;

-- --------------------------------------------------------

--
-- Table structure for table `exams`
--

CREATE TABLE IF NOT EXISTS `exams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `exam_logs`
--

CREATE TABLE IF NOT EXISTS `exam_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `action` varchar(100) NOT NULL,
  `details` text DEFAULT NULL,
  `log_time` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `exam_id` (`exam_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `files`
--

CREATE TABLE IF NOT EXISTS `files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inline_button_id` int(11) NOT NULL,
  `file_type` varchar(50) NOT NULL,
  `file_path` varchar(255) NOT NULL,
  `caption` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `inline_button_id` (`inline_button_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `files`
--

INSERT INTO `files` (`id`, `inline_button_id`, `file_type`, `file_path`, `caption`, `created_at`) VALUES
(3, 4, 'document', 'uploads/1740488494_Test.txt', 'Test File', '2025-02-25 13:01:34');

-- --------------------------------------------------------

--
-- Table structure for table `inline_buttons`
--

CREATE TABLE IF NOT EXISTS `inline_buttons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `main_button_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `main_button_id` (`main_button_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `inline_buttons`
--

INSERT INTO `inline_buttons` (`id`, `main_button_id`, `title`, `description`, `created_at`) VALUES
(3, 5, 'تست یک', 'تست یک', '2025-02-25 12:31:01'),
(4, 1, 'تست دو', 'تست دو', '2025-02-25 12:31:11'),
(5, 2, 'تست سه', 'تست سه', '2025-02-25 12:31:21'),
(6, 4, 'تست چهار', 'تست چهار', '2025-02-25 12:31:31'),
(7, 3, 'تست پنج', 'تست پنج', '2025-02-25 12:31:47'),
(8, 6, 'تست شش', 'تست شش', '2025-02-25 12:31:55');

-- --------------------------------------------------------

--
-- Table structure for table `main_buttons`
--

CREATE TABLE IF NOT EXISTS `main_buttons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `main_buttons`
--

INSERT INTO `main_buttons` (`id`, `title`, `created_at`) VALUES
(1, '📯️ Microsoft Excel', '2025-02-25 12:08:38'),
(2, '📃 Microsoft Word', '2025-02-25 12:08:49'),
(3, '📺 Microsoft Powerpoint', '2025-02-25 12:08:55'),
(4, '📹 Microsoft Access', '2025-02-25 12:09:04'),
(5, '☻️ VisualBasicForApplications', '2025-02-25 12:09:10'),
(6, '💻 Computer_Internet', '2025-02-25 12:09:16');

-- --------------------------------------------------------

--
-- Table structure for table `options`
--

CREATE TABLE IF NOT EXISTS `options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `question_id` int(11) NOT NULL,
  `option_text` varchar(255) NOT NULL,
  `is_correct` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `question_id` (`question_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `questions`
--

CREATE TABLE IF NOT EXISTS `questions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_id` int(11) NOT NULL,
  `question_text` text NOT NULL,
  `question_type` enum('multiple','descriptive') DEFAULT 'multiple',
  `score` int(11) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `exam_id` (`exam_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `results`
--

CREATE TABLE IF NOT EXISTS `results` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `score` int(11) DEFAULT 0,
  `submitted_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `exam_user_unique` (`exam_id`,`user_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `suggested_files`
--

CREATE TABLE IF NOT EXISTS `suggested_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `file_url` varchar(255) NOT NULL,
  `submission_time` timestamp NULL DEFAULT current_timestamp(),
  `status` enum('pending','approved','rejected') DEFAULT 'pending',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `suggested_files`
--

INSERT INTO `suggested_files` (`id`, `user_id`, `file_url`, `submission_time`, `status`) VALUES
(1, 1, 'BQACAgQAAxkDAAICiGe9v1C-dIAprRmAixlwZWu0cdHvAALzFgAC15DoUQPyXVyoGOPwNgQ', '2025-02-25 16:57:53', 'approved');

-- --------------------------------------------------------

--
-- Table structure for table `user_answers`
--

CREATE TABLE IF NOT EXISTS `user_answers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `question_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `option_id` int(11) DEFAULT NULL,
  `text_answer` text DEFAULT NULL,
  `answer_time` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `question_id` (`question_id`),
  KEY `user_id` (`user_id`),
  KEY `option_id` (`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `telegram_id` varchar(50) NOT NULL,
  `username` varchar(255) DEFAULT NULL,
  `full_name` varchar(255) DEFAULT NULL,
  `start_time` timestamp NULL DEFAULT current_timestamp(),
  `last_usage` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` enum('active','blocked') DEFAULT 'active',
  PRIMARY KEY (`id`),
  UNIQUE KEY `telegram_id` (`telegram_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `telegram_id`, `username`, `full_name`, `start_time`, `last_usage`, `status`) VALUES
(1, '867325725', 'Amin_Dv', 'امین', '2025-02-25 16:48:39', '2025-02-25 20:08:19', 'active'),
(2, '1188184922', 'Ok_Suck', 'امین', '2025-02-25 18:42:10', '2025-02-25 19:51:36', 'active');

--
-- Constraints for dumped tables
--

--
-- Constraints for table `exam_logs`
--
ALTER TABLE `exam_logs`
  ADD CONSTRAINT `exam_logs_ibfk_1` FOREIGN KEY (`exam_id`) REFERENCES `exams` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `files`
--
ALTER TABLE `files`
  ADD CONSTRAINT `files_ibfk_1` FOREIGN KEY (`inline_button_id`) REFERENCES `inline_buttons` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `inline_buttons`
--
ALTER TABLE `inline_buttons`
  ADD CONSTRAINT `inline_buttons_ibfk_1` FOREIGN KEY (`main_button_id`) REFERENCES `main_buttons` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `options`
--
ALTER TABLE `options`
  ADD CONSTRAINT `options_ibfk_1` FOREIGN KEY (`question_id`) REFERENCES `questions` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `questions`
--
ALTER TABLE `questions`
  ADD CONSTRAINT `questions_ibfk_1` FOREIGN KEY (`exam_id`) REFERENCES `exams` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `results`
--
ALTER TABLE `results`
  ADD CONSTRAINT `results_ibfk_1` FOREIGN KEY (`exam_id`) REFERENCES `exams` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `results_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `suggested_files`
--
ALTER TABLE `suggested_files`
  ADD CONSTRAINT `suggested_files_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `user_answers`
--
ALTER TABLE `user_answers`
  ADD CONSTRAINT `user_answers_ibfk_1` FOREIGN KEY (`question_id`) REFERENCES `questions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `user_answers_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `user_answers_ibfk_3` FOREIGN KEY (`option_id`) REFERENCES `options` (`id`) ON DELETE SET NULL;
COMMIT;

-- --------------------------------------------------------
-- ارتقای جداول آزمون برای امکانات پیشرفته (در صورت وجود جدول)

-- جدول questions: افزودن سطح دشواری، تصویر، نمره منفی
ALTER TABLE `questions`
  ADD COLUMN `difficulty_level` ENUM('easy','medium','hard') DEFAULT 'medium' AFTER `question_type`,
  ADD COLUMN `image_url` VARCHAR(255) DEFAULT NULL AFTER `difficulty_level`,
  ADD COLUMN `negative_score` INT DEFAULT 0 AFTER `score`;

-- جدول options: افزودن تصویر گزینه و امتیاز اختصاصی گزینه
ALTER TABLE `options`
  ADD COLUMN `option_image_url` VARCHAR(255) DEFAULT NULL AFTER `option_text`,
  ADD COLUMN `option_score` INT DEFAULT 0 AFTER `is_correct`;

-- جدول user_answers: افزودن مدت زمان پاسخ و وضعیت پاسخ
ALTER TABLE `user_answers`
  ADD COLUMN `response_duration` INT DEFAULT NULL AFTER `answer_time`,
  ADD COLUMN `answer_status` ENUM('correct','wrong','skipped') DEFAULT NULL AFTER `response_duration`;

-- جدول results: افزودن رتبه و جزئیات کارنامه
ALTER TABLE `results`
  ADD COLUMN `rank` INT DEFAULT NULL AFTER `score`,
  ADD COLUMN `details` TEXT DEFAULT NULL AFTER `rank`;

-- جدول user_question_sessions: نگهداری زمان شروع هر سوال برای هر کاربر
CREATE TABLE IF NOT EXISTS `user_question_sessions` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `user_id` INT NOT NULL,
  `question_id` INT NOT NULL,
  `start_time` DATETIME NOT NULL,
  UNIQUE KEY `uq_user_question` (`user_id`, `question_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- پایان ارتقا

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
