<?php
session_start();
require_once 'config.php';

try {
    $pdo = new PDO('mysql:host=' . DB_HOST . ';dbname=' . DB_NAME.';charset=utf8mb4', DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->exec("SET NAMES utf8mb4");
} catch (PDOException $e) {
    $_SESSION['message'] = "<div class='alert alert-danger'>خطا در اتصال به پایگاه داده: " . $e->getMessage() . "</div>";
    header("Location: admin.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    if ($action === 'add_main_button') {
        $title = trim($_POST['title'] ?? '');
        if (!empty($title)) {
            $stmt = $pdo->prepare("INSERT INTO main_buttons (title) VALUES (:title)");
            if ($stmt->execute([':title' => $title])) {
                $_SESSION['message'] = "<div class='alert alert-success'>دکمه اصلی با موفقیت اضافه شد.</div>";
            } else {
                $_SESSION['message'] = "<div class='alert alert-danger'>خطا در افزودن دکمه اصلی.</div>";
            }
        } else {
            $_SESSION['message'] = "<div class='alert alert-danger'>عنوان دکمه اصلی نمی‌تواند خالی باشد.</div>";
        }
        header("Location: admin.php");
        exit;
    } elseif ($action === 'edit_main_button') {
        $id = intval($_POST['id'] ?? 0);
        $title = trim($_POST['title'] ?? '');
        if ($id > 0 && !empty($title)) {
            $stmt = $pdo->prepare("UPDATE main_buttons SET title = :title WHERE id = :id");
            if ($stmt->execute([':title' => $title, ':id' => $id])) {
                $_SESSION['message'] = "<div class='alert alert-success'>دکمه اصلی با موفقیت ویرایش شد.</div>";
            } else {
                $_SESSION['message'] = "<div class='alert alert-danger'>خطا در ویرایش دکمه اصلی.</div>";
            }
        } else {
            $_SESSION['message'] = "<div class='alert alert-danger'>اطلاعات وارد شده نامعتبر است.</div>";
        }
        header("Location: admin.php");
        exit;
    } elseif ($action === 'add_inline_button') {
        $main_button_id = intval($_POST['main_button_id'] ?? 0);
        $inline_title = trim($_POST['inline_title'] ?? '');
        $description = trim($_POST['description'] ?? '');
        if ($main_button_id > 0 && !empty($inline_title)) {
            $stmt = $pdo->prepare("INSERT INTO inline_buttons (main_button_id, title, description) VALUES (:mbid, :title, :description)");
            if ($stmt->execute([':mbid' => $main_button_id, ':title' => $inline_title, ':description' => $description])) {
                $_SESSION['message'] = "<div class='alert alert-success'>دکمه اینلاین با موفقیت اضافه شد.</div>";
            } else {
                $_SESSION['message'] = "<div class='alert alert-danger'>خطا در افزودن دکمه اینلاین.</div>";
            }
        } else {
            $_SESSION['message'] = "<div class='alert alert-danger'>عنوان دکمه اینلاین نمی‌تواند خالی باشد.</div>";
        }
        header("Location: admin.php");
        exit;
    } elseif ($action === 'edit_inline_button') {
        $id = intval($_POST['id'] ?? 0);
        $inline_title = trim($_POST['inline_title'] ?? '');
        $description = trim($_POST['description'] ?? '');
        if ($id > 0 && !empty($inline_title)) {
            $stmt = $pdo->prepare("UPDATE inline_buttons SET title = :title, description = :description WHERE id = :id");
            if ($stmt->execute([':title' => $inline_title, ':description' => $description, ':id' => $id])) {
                $_SESSION['message'] = "<div class='alert alert-success'>دکمه اینلاین با موفقیت ویرایش شد.</div>";
            } else {
                $_SESSION['message'] = "<div class='alert alert-danger'>خطا در ویرایش دکمه اینلاین.</div>";
            }
        } else {
            $_SESSION['message'] = "<div class='alert alert-danger'>اطلاعات وارد شده نامعتبر است.</div>";
        }
        header("Location: admin.php");
        exit;
    } elseif ($action === 'upload_file') {
        $inline_button_id = intval($_POST['inline_button_id'] ?? 0);
        $file_type = $_POST['file_type'] ?? '';
        $caption = trim($_POST['caption'] ?? '');
        if ($inline_button_id > 0 && isset($_FILES['file']) && $_FILES['file']['error'] == UPLOAD_ERR_OK) {
            $uploadDir = __DIR__ . '/uploads/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }
            $fileName = basename($_FILES['file']['name']);
            $targetFile = $uploadDir . time() . "_" . $fileName;
            if (move_uploaded_file($_FILES['file']['tmp_name'], $targetFile)) {
                $stmt = $pdo->prepare("INSERT INTO files (inline_button_id, file_type, file_path, caption) VALUES (:ibid, :ftype, :fpath, :caption)");
                if ($stmt->execute([':ibid' => $inline_button_id, ':ftype' => $file_type, ':fpath' => $targetFile, ':caption' => $caption])) {
                    $_SESSION['message'] = "<div class='alert alert-success'>فایل با موفقیت آپلود شد.</div>";
                } else {
                    $_SESSION['message'] = "<div class='alert alert-danger'>خطا در ذخیره اطلاعات فایل.</div>";
                }
            } else {
                $_SESSION['message'] = "<div class='alert alert-danger'>خطا در آپلود فایل.</div>";
            }
        } else {
            $_SESSION['message'] = "<div class='alert alert-danger'>اطلاعات فایل وارد شده نامعتبر است.</div>";
        }
        header("Location: admin.php");
        exit;
    } elseif ($action === 'edit_file') {
        $id = intval($_POST['id'] ?? 0);
        $caption = trim($_POST['caption'] ?? '');
        if ($id > 0) {
            $stmt = $pdo->prepare("UPDATE files SET caption = :caption WHERE id = :id");
            if ($stmt->execute([':caption' => $caption, ':id' => $id])) {
                $_SESSION['message'] = "<div class='alert alert-success'>فایل با موفقیت ویرایش شد.</div>";
            } else {
                $_SESSION['message'] = "<div class='alert alert-danger'>خطا در ویرایش فایل.</div>";
            }
        } else {
            $_SESSION['message'] = "<div class='alert alert-danger'>اطلاعات فایل وارد شده نامعتبر است.</div>";
        }
        header("Location: admin.php");
        exit;
    } elseif ($action === 'add_exam') {
        $title = trim($_POST['title'] ?? '');
        $description = trim($_POST['description'] ?? '');
        $start_time = trim($_POST['start_time'] ?? '');
        $end_time = trim($_POST['end_time'] ?? '');
        
        if (!empty($title) && !empty($start_time) && !empty($end_time)) {
            $stmt = $pdo->prepare("
                INSERT INTO exams (title, description, start_time, end_time)
                VALUES (:title, :description, :start_time, :end_time)
            ");
            
            if ($stmt->execute([
                ':title' => $title,
                ':description' => $description,
                ':start_time' => $start_time,
                ':end_time' => $end_time
            ])) {
                $_SESSION['message'] = "<div class='alert alert-success'>آزمون جدید با موفقیت اضافه شد.</div>";
            } else {
                $_SESSION['message'] = "<div class='alert alert-danger'>خطا در افزودن آزمون جدید.</div>";
            }
        } else {
            $_SESSION['message'] = "<div class='alert alert-danger'>لطفاً تمام فیلدهای ضروری را پر کنید.</div>";
        }
        
        header("Location: admin.php");
        exit;
    } elseif ($action === 'add_question') {
        $exam_id = intval($_POST['exam_id'] ?? 0);
        $question_text = trim($_POST['question_text'] ?? '');
        $question_type = trim($_POST['question_type'] ?? 'multiple');
        $score = intval($_POST['score'] ?? 1);
        
        if ($exam_id > 0 && !empty($question_text)) {
            // افزودن سوال
            $stmt = $pdo->prepare("
                INSERT INTO questions (exam_id, question_text, question_type, score)
                VALUES (:exam_id, :question_text, :question_type, :score)
            ");
            
            if ($stmt->execute([
                ':exam_id' => $exam_id,
                ':question_text' => $question_text,
                ':question_type' => $question_type,
                ':score' => $score
            ])) {
                $question_id = $pdo->lastInsertId();
                
                // اگر سوال چندگزینه‌ای است، گزینه‌ها را ذخیره کنید
                if ($question_type === 'multiple' && isset($_POST['options']) && is_array($_POST['options'])) {
                    foreach ($_POST['options'] as $key => $option) {
                        if (!empty($option['text'])) {
                            $is_correct = isset($option['is_correct']) ? 1 : 0;
                            
                            $stmt = $pdo->prepare("
                                INSERT INTO options (question_id, option_text, is_correct)
                                VALUES (:question_id, :option_text, :is_correct)
                            ");
                            
                            $stmt->execute([
                                ':question_id' => $question_id,
                                ':option_text' => $option['text'],
                                ':is_correct' => $is_correct
                            ]);
                        }
                    }
                }
                
                $_SESSION['message'] = "<div class='alert alert-success'>سوال با موفقیت اضافه شد.</div>";
            } else {
                $_SESSION['message'] = "<div class='alert alert-danger'>خطا در افزودن سوال.</div>";
            }
        } else {
            $_SESSION['message'] = "<div class='alert alert-danger'>لطفاً متن سوال را وارد کنید.</div>";
        }
        
        header("Location: admin.php?tab=exams&exam_id={$exam_id}");
        exit;
    } else {
         $_SESSION['message'] = "<div class='alert alert-danger'>عملیات نامعتبر.</div>";
         header("Location: admin.php");
         exit;
    }
} elseif ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $action = $_GET['action'] ?? '';
    if ($action === 'delete_main_button') {
         $id = intval($_GET['id'] ?? 0);
         if ($id > 0) {
             $stmt = $pdo->prepare("DELETE FROM main_buttons WHERE id = :id");
             if ($stmt->execute([':id' => $id])) {
                 $_SESSION['message'] = "<div class='alert alert-success'>دکمه اصلی با موفقیت حذف شد.</div>";
             } else {
                 $_SESSION['message'] = "<div class='alert alert-danger'>خطا در حذف دکمه اصلی.</div>";
             }
         } else {
             $_SESSION['message'] = "<div class='alert alert-danger'>شناسه نامعتبر.</div>";
         }
         header("Location: admin.php");
         exit;
    } elseif ($action === 'delete_inline_button') {
         $id = intval($_GET['id'] ?? 0);
         if ($id > 0) {
             $stmt = $pdo->prepare("DELETE FROM inline_buttons WHERE id = :id");
             if ($stmt->execute([':id' => $id])) {
                 $_SESSION['message'] = "<div class='alert alert-success'>دکمه اینلاین با موفقیت حذف شد.</div>";
             } else {
                 $_SESSION['message'] = "<div class='alert alert-danger'>خطا در حذف دکمه اینلاین.</div>";
             }
         } else {
             $_SESSION['message'] = "<div class='alert alert-danger'>شناسه نامعتبر.</div>";
         }
         header("Location: admin.php");
         exit;
    } elseif ($action === 'delete_file') {
         $id = intval($_GET['id'] ?? 0);
         if ($id > 0) {
             $stmt = $pdo->prepare("SELECT file_path FROM files WHERE id = :id");
             $stmt->execute([':id' => $id]);
             $file = $stmt->fetch(PDO::FETCH_ASSOC);
             if ($file && file_exists($file['file_path'])) {
                 unlink($file['file_path']);
             }
             $stmt = $pdo->prepare("DELETE FROM files WHERE id = :id");
             if ($stmt->execute([':id' => $id])) {
                 $_SESSION['message'] = "<div class='alert alert-success'>فایل با موفقیت حذف شد.</div>";
             } else {
                 $_SESSION['message'] = "<div class='alert alert-danger'>خطا در حذف فایل.</div>";
             }
         } else {
             $_SESSION['message'] = "<div class='alert alert-danger'>شناسه نامعتبر.</div>";
         }
         header("Location: admin.php");
         exit;
    } elseif ($action === 'toggle_user') {
         $id = intval($_GET['id'] ?? 0);
         $toggle = $_GET['toggle'] ?? '';
         if ($id > 0) {
             if ($toggle === 'block') {
                 $stmt = $pdo->prepare("UPDATE users SET status = 'blocked' WHERE id = :id");
             } elseif ($toggle === 'unblock') {
                 $stmt = $pdo->prepare("UPDATE users SET status = 'active' WHERE id = :id");
             } else {
                 $_SESSION['message'] = "<div class='alert alert-danger'>عملیات نامعتبر.</div>";
                 header("Location: admin.php");
                 exit;
             }
             if ($stmt->execute([':id' => $id])) {
                 $_SESSION['message'] = "<div class='alert alert-success'>وضعیت کاربر با موفقیت به‌روزرسانی شد.</div>";
             } else {
                 $_SESSION['message'] = "<div class='alert alert-danger'>خطا در به‌روزرسانی وضعیت کاربر.</div>";
             }
         } else {
             $_SESSION['message'] = "<div class='alert alert-danger'>شناسه نامعتبر.</div>";
         }
         header("Location: admin.php");
         exit;
    } elseif ($action === 'approve_suggested') {
         $id = intval($_GET['id'] ?? 0);
         if ($id > 0) {
             $stmt = $pdo->prepare("UPDATE suggested_files SET status = 'approved' WHERE id = :id");
             if ($stmt->execute([':id' => $id])) {
                 // ارسال پیام به کاربر جهت اطلاع از تایید فایل پیشنهادی
                 $stmtUser = $pdo->prepare("SELECT telegram_id FROM users WHERE id = (SELECT user_id FROM suggested_files WHERE id = :id LIMIT 1)");
                 $stmtUser->execute([':id' => $id]);
                 $user = $stmtUser->fetch(PDO::FETCH_ASSOC);
                 if ($user) {
                     require_once 'telegram_api.php';
                     sendMessage($user['telegram_id'], "فایل پیشنهادی شما تایید شد.");
                 }
                 $_SESSION['message'] = "<div class='alert alert-success'>فایل پیشنهادی تایید شد.</div>";
             } else {
                 $_SESSION['message'] = "<div class='alert alert-danger'>خطا در تایید فایل پیشنهادی.</div>";
             }
         } else {
             $_SESSION['message'] = "<div class='alert alert-danger'>شناسه نامعتبر.</div>";
         }
         header("Location: admin.php");
         exit;
    } elseif ($action === 'reject_suggested') {
         $id = intval($_GET['id'] ?? 0);
         if ($id > 0) {
             $stmt = $pdo->prepare("UPDATE suggested_files SET status = 'rejected' WHERE id = :id");
             if ($stmt->execute([':id' => $id])) {
                 $stmtUser = $pdo->prepare("SELECT telegram_id FROM users WHERE id = (SELECT user_id FROM suggested_files WHERE id = :id LIMIT 1)");
                 $stmtUser->execute([':id' => $id]);
                 $user = $stmtUser->fetch(PDO::FETCH_ASSOC);
                 if ($user) {
                     require_once 'telegram_api.php';
                     sendMessage($user['telegram_id'], "فایل پیشنهادی شما رد شد.");
                 }
                 $_SESSION['message'] = "<div class='alert alert-success'>فایل پیشنهادی رد شد.</div>";
             } else {
                 $_SESSION['message'] = "<div class='alert alert-danger'>خطا در رد فایل پیشنهادی.</div>";
             }
         } else {
             $_SESSION['message'] = "<div class='alert alert-danger'>شناسه نامعتبر.</div>";
         }
         header("Location: admin.php");
         exit;
    } elseif ($action === 'delete_exam') {
        $id = intval($_GET['id'] ?? 0);
        if ($id > 0) {
            // حذف سوالات و گزینه‌ها
            $stmt = $pdo->prepare("
                DELETE options FROM options 
                INNER JOIN questions ON options.question_id = questions.id
                WHERE questions.exam_id = :exam_id
            ");
            $stmt->execute([':exam_id' => $id]);
            
            // حذف سوالات
            $stmt = $pdo->prepare("DELETE FROM questions WHERE exam_id = :exam_id");
            $stmt->execute([':exam_id' => $id]);
            
            // حذف نتایج آزمون
            $stmt = $pdo->prepare("DELETE FROM results WHERE exam_id = :exam_id");
            $stmt->execute([':exam_id' => $id]);
            
            // حذف لاگ‌های آزمون
            $stmt = $pdo->prepare("DELETE FROM exam_logs WHERE exam_id = :exam_id");
            $stmt->execute([':exam_id' => $id]);
            
            // حذف پاسخ‌های کاربران
            $stmt = $pdo->prepare("
                DELETE user_answers FROM user_answers 
                INNER JOIN questions ON user_answers.question_id = questions.id
                WHERE questions.exam_id = :exam_id
            ");
            $stmt->execute([':exam_id' => $id]);
            
            // حذف آزمون
            $stmt = $pdo->prepare("DELETE FROM exams WHERE id = :id");
            if ($stmt->execute([':id' => $id])) {
                $_SESSION['message'] = "<div class='alert alert-success'>آزمون با موفقیت حذف شد.</div>";
            } else {
                $_SESSION['message'] = "<div class='alert alert-danger'>خطا در حذف آزمون.</div>";
            }
        } else {
            $_SESSION['message'] = "<div class='alert alert-danger'>شناسه نامعتبر.</div>";
        }
        header("Location: admin.php");
        exit;
    } elseif ($action === 'delete_question') {
        $id = intval($_GET['id'] ?? 0);
        $exam_id = intval($_GET['exam_id'] ?? 0);
        
        if ($id > 0 && $exam_id > 0) {
            // حذف گزینه‌های سوال
            $stmt = $pdo->prepare("DELETE FROM options WHERE question_id = :question_id");
            $stmt->execute([':question_id' => $id]);
            
            // حذف پاسخ‌های کاربران به این سوال
            $stmt = $pdo->prepare("DELETE FROM user_answers WHERE question_id = :question_id");
            $stmt->execute([':question_id' => $id]);
            
            // حذف سوال
            $stmt = $pdo->prepare("DELETE FROM questions WHERE id = :id");
            if ($stmt->execute([':id' => $id])) {
                $_SESSION['message'] = "<div class='alert alert-success'>سوال با موفقیت حذف شد.</div>";
            } else {
                $_SESSION['message'] = "<div class='alert alert-danger'>خطا در حذف سوال.</div>";
            }
        } else {
            $_SESSION['message'] = "<div class='alert alert-danger'>شناسه نامعتبر.</div>";
        }
        
        header("Location: admin.php?tab=exams&exam_id={$exam_id}");
        exit;
    } elseif ($action === 'edit_exam') {
        $id = intval($_GET['id'] ?? 0);
        
        if ($id > 0) {
            $stmt = $pdo->prepare("SELECT * FROM exams WHERE id = :id");
            $stmt->execute([':id' => $id]);
            $exam = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($exam) {
                $_SESSION['edit_exam'] = $exam;
                header("Location: admin.php?tab=edit_exam&id={$id}");
                exit;
            } else {
                $_SESSION['message'] = "<div class='alert alert-danger'>آزمون مورد نظر یافت نشد.</div>";
            }
        } else {
            $_SESSION['message'] = "<div class='alert alert-danger'>شناسه نامعتبر.</div>";
        }
        
        header("Location: admin.php");
        exit;
    } elseif ($action === 'duplicate_exam') {
        $id = intval($_GET['id'] ?? 0);
        
        if ($id > 0) {
            // کپی آزمون
            $stmt = $pdo->prepare("
                INSERT INTO exams (title, description, start_time, end_time)
                SELECT CONCAT(title, ' (کپی)'), description, DATE_ADD(NOW(), INTERVAL 1 DAY), DATE_ADD(end_time, INTERVAL 1 DAY)
                FROM exams
                WHERE id = :id
            ");
            
            if ($stmt->execute([':id' => $id])) {
                $new_exam_id = $pdo->lastInsertId();
                
                // کپی سوالات
                $stmt = $pdo->prepare("
                    INSERT INTO questions (exam_id, question_text, question_type, score)
                    SELECT :new_exam_id, question_text, question_type, score
                    FROM questions
                    WHERE exam_id = :old_exam_id
                ");
                
                if ($stmt->execute([':new_exam_id' => $new_exam_id, ':old_exam_id' => $id])) {
                    // نگاشت ID سوالات قدیمی به جدید
                    $question_map = [];
                    
                    $stmt_old = $pdo->prepare("SELECT id FROM questions WHERE exam_id = :exam_id");
                    $stmt_old->execute([':exam_id' => $id]);
                    $old_question_ids = $stmt_old->fetchAll(PDO::FETCH_COLUMN);
                    
                    $stmt_new = $pdo->prepare("SELECT id FROM questions WHERE exam_id = :exam_id");
                    $stmt_new->execute([':exam_id' => $new_exam_id]);
                    $new_question_ids = $stmt_new->fetchAll(PDO::FETCH_COLUMN);
                    
                    for ($i = 0; $i < count($old_question_ids); $i++) {
                        if (isset($new_question_ids[$i])) {
                            $question_map[$old_question_ids[$i]] = $new_question_ids[$i];
                        }
                    }
                    
                    // کپی گزینه‌ها
                    foreach ($question_map as $old_id => $new_id) {
                        $stmt = $pdo->prepare("
                            INSERT INTO options (question_id, option_text, is_correct)
                            SELECT :new_question_id, option_text, is_correct
                            FROM options
                            WHERE question_id = :old_question_id
                        ");
                        
                        $stmt->execute([
                            ':new_question_id' => $new_id,
                            ':old_question_id' => $old_id
                        ]);
                    }
                    
                    $_SESSION['message'] = "<div class='alert alert-success'>آزمون با موفقیت کپی شد.</div>";
                } else {
                    $_SESSION['message'] = "<div class='alert alert-danger'>خطا در کپی سوالات آزمون.</div>";
                }
            } else {
                $_SESSION['message'] = "<div class='alert alert-danger'>خطا در کپی آزمون.</div>";
            }
        } else {
            $_SESSION['message'] = "<div class='alert alert-danger'>شناسه نامعتبر.</div>";
        }
        
        header("Location: admin.php");
        exit;
    } elseif ($action === 'export_results') {
        $exam_id = intval($_GET['exam_id'] ?? 0);
        
        if ($exam_id > 0) {
            // دریافت اطلاعات آزمون
            $stmt = $pdo->prepare("SELECT title FROM exams WHERE id = :id");
            $stmt->execute([':id' => $exam_id]);
            $exam_title = $stmt->fetchColumn();
            
            // دریافت نتایج
            $stmt = $pdo->prepare("
                SELECT u.telegram_id, u.username, u.full_name, r.score, r.submitted_at
                FROM results r
                JOIN users u ON r.user_id = u.id
                WHERE r.exam_id = :exam_id
                ORDER BY r.score DESC
            ");
            $stmt->execute([':exam_id' => $exam_id]);
            $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            // ساخت فایل CSV
            $csv = "شناسه تلگرام,نام کاربری,نام کامل,نمره,تاریخ ارسال\n";
            foreach ($results as $row) {
                $csv .= "{$row['telegram_id']},{$row['username']},{$row['full_name']},{$row['score']},{$row['submitted_at']}\n";
            }
            
            // ارسال فایل CSV به مرورگر
            header('Content-Type: text/csv; charset=utf-8');
            header('Content-Disposition: attachment; filename="' . $exam_title . '_results.csv"');
            echo $csv;
            exit;
        } else {
            $_SESSION['message'] = "<div class='alert alert-danger'>شناسه آزمون نامعتبر است.</div>";
            header("Location: admin.php");
            exit;
        }
    } else {
         $_SESSION['message'] = "<div class='alert alert-danger'>عملیات نامعتبر.</div>";
         header("Location: admin.php");
         exit;
    }
} else {
    $_SESSION['message'] = "<div class='alert alert-danger'>درخواست نامعتبر.</div>";
    header("Location: admin.php");
    exit;
}
?>
