<?php
session_start();
require_once 'config.php';

try {
    $pdo = new PDO('mysql:host='.DB_HOST.';dbname='.DB_NAME.';charset=utf8mb4', DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->exec("SET NAMES utf8mb4");
} catch(PDOException $e) {
    $_SESSION['message'] = "<div class='alert alert-danger'>خطا در اتصال به پایگاه داده: " . $e->getMessage() . "</div>";
    header("Location: admin.php");
    exit;
}

// بررسی ورود ادمین
$loggedIn = isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: admin.php");
    exit;
}
if (!$loggedIn && isset($_POST['username']) && isset($_POST['password'])) {
    $adminUsername = 'Senior';
    $adminPassword = 'Amin$Vip9'; // مقدار مناسب را وارد کنید
    if ($_POST['username'] === $adminUsername && $_POST['password'] === $adminPassword) {
        $_SESSION['admin_logged_in'] = true;
        $loggedIn = true;
    } else {
        $error = "نام کاربری یا رمز عبور اشتباه است.";
    }
}
if (!$loggedIn):
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <title>ورود به پنل مدیریت</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;700&display=swap" rel="stylesheet">
  <style>
    body {
      font-family: 'Vazirmatn', sans-serif;
      background: linear-gradient(135deg, #0088cc, #00c6ff);
      margin: 0;
      padding: 0;
      height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      text-align: right;
    }
    .login-container {
      background: #fff;
      padding: 25px;
      border-radius: 8px;
      width: 100%;
      max-width: 400px;
      box-shadow: 0 0 15px rgba(0,0,0,0.1);
    }
    .login-container h2 {
      margin-bottom: 20px;
      text-align: center;
      color: #007bff;
    }
    .login-container label {
      float: right;
    }
    .login-container .form-control {
      direction: rtl;
      text-align: right;
    }
    .btn-primary {
      background-color: #007bff;
      border-color: #007bff;
    }
  </style>
</head>
<body>
  <div class="login-container">
    <h2><i class="fas fa-user-shield"></i> پنل مدیریت</h2>
    <?php if(isset($error)) echo "<div class='alert alert-danger text-center'>$error</div>"; ?>
    <form method="post">
      <div class="form-group">
        <label>نام کاربری:</label>
        <input type="text" name="username" class="form-control" required>
      </div>
      <div class="form-group">
        <label>رمز عبور:</label>
        <input type="password" name="password" class="form-control" required>
      </div>
      <button type="submit" class="btn btn-primary btn-block">ورود</button>
    </form>
  </div>
</body>
</html>
<?php
    exit;
endif;
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <title>داشبورد مدیریت ربات آموزشی</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;700&display=swap" rel="stylesheet">
  <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <style>
    body {
      font-family: 'Vazirmatn', sans-serif;
      background: #f5f8fa;
      margin: 0;
      padding: 0;
      color: #333;
      text-align: right;
    }
    .navbar {
      background: #007bff !important;
    }
    .navbar-brand, .nav-link, .navbar-text {
      color: #fff !important;
    }
    /* تب‌ها: تب فعال با پس‌زمینه سفید و متن آبی */
    .nav-tabs .nav-link {
      background-color: #007bff;
      color: #fff;
      margin-right: 5px;
      margin-bottom: -1px;
      border: 1px solid transparent;
      border-top-left-radius: .25rem;
      border-top-right-radius: .25rem;
    }
    .nav-tabs .nav-link.active {
      background-color: #fff !important;
      color: #007bff !important;
      border: 1px solid #dee2e6;
      border-bottom: none;
    }
    .tab-content {
      background: #fff;
      padding: 20px;
      border: 1px solid #dee2e6;
      border-top: none;
      border-radius: 0 0 5px 5px;
      min-height: 60vh;
    }
    .flash-message {
      position: fixed;
      top: 15px;
      right: 15px;
      z-index: 9999;
      min-width: 250px;
      opacity: 0.95;
    }
    /* کارت‌های آماری */
    .small-box {
      border-radius: 6px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      color: #fff;
      padding: 20px;
      margin-bottom: 15px;
      position: relative;
      overflow: hidden;
    }
    .small-box .inner h3 {
      font-size: 2rem;
      font-weight: 700;
      margin: 0;
      padding: 0;
    }
    .small-box .inner p {
      font-size: 1.1rem;
      margin: 5px 0 0;
    }
    .small-box .icon {
      position: absolute;
      top: 10px;
      left: 10px;
      font-size: 50px;
      opacity: 0.2;
    }
    .bg-info { background-color: #17a2b8 !important; }
    .bg-success { background-color: #28a745 !important; }
    .bg-warning { background-color: #ffc107 !important; color: #212529 !important; }
    .bg-primary { background-color: #007bff !important; }
    .bg-secondary { background-color: #6c757d !important; }
    .table-responsive { margin-top: 15px; }
    .modal .modal-header { background: #007bff; color: #fff; }
    .modal .modal-footer .btn-secondary { background: #6c757d; }
    .modal .modal-footer .btn-primary { background: #007bff; }
    /* فاصله بین دکمه‌های عملیات */
    .btn + .btn { margin-right: 5px; }
    canvas { max-width: 100% !important; }
  </style>
</head>
<body>
  <!-- هدر -->
  <nav class="navbar navbar-expand-md">
    <div class="container-fluid">
      <div class="d-flex w-100 justify-content-between align-items-center">
        <span class="navbar-brand mb-0 h1"><i class="fas fa-robot"></i> مدیریت ربات</span>
        <a href="admin.php?logout=1" class="btn btn-outline-light"><i class="fas fa-sign-out-alt"></i> خروج</a>
      </div>
    </div>
  </nav>

  <!-- پیام‌های فلش -->
  <?php if(isset($_SESSION['message'])): ?>
    <div class="flash-message alert alert-info">
      <?php 
        echo $_SESSION['message'];
        unset($_SESSION['message']);
      ?>
    </div>
  <?php endif; ?>

  <!-- محتوای اصلی پنل -->
  <div class="container-fluid mt-3">
    <ul class="nav nav-tabs" id="mainTabs" role="tablist">
      <li class="nav-item">
        <a class="nav-link active" id="dashboard-tab" data-toggle="tab" href="#dashboard" role="tab">داشبورد</a>
      </li>
      <li class="nav-item">
        <a class="nav-link" id="addMain-tab" data-toggle="tab" href="#addMain" role="tab">افزودن دکمه اصلی</a>
      </li>
      <li class="nav-item">
        <a class="nav-link" id="addInline-tab" data-toggle="tab" href="#addInline" role="tab">افزودن دکمه اینلاین</a>
      </li>
      <li class="nav-item">
        <a class="nav-link" id="uploadFile-tab" data-toggle="tab" href="#uploadFile" role="tab">آپلود فایل</a>
      </li>
      <li class="nav-item">
        <a class="nav-link" id="manageMain-tab" data-toggle="tab" href="#manageMain" role="tab">مدیریت دکمه اصلی</a>
      </li>
      <li class="nav-item">
        <a class="nav-link" id="manageInline-tab" data-toggle="tab" href="#manageInline" role="tab">مدیریت دکمه اینلاین</a>
      </li>
      <li class="nav-item">
        <a class="nav-link" id="manageFiles-tab" data-toggle="tab" href="#manageFiles" role="tab">مدیریت فایل‌ها</a>
      </li>
      <li class="nav-item">
        <a class="nav-link" id="userManagement-tab" data-toggle="tab" href="#userManagement" role="tab">مدیریت کاربران</a>
      </li>
      <li class="nav-item">
        <a class="nav-link" id="suggestedFiles-tab" data-toggle="tab" href="#suggestedFiles" role="tab">فایل‌های پیشنهادی</a>
      </li>
      <li class="nav-item">
        <a class="nav-link" id="manageExams-tab" data-toggle="tab" href="#manageExams" role="tab">مدیریت آزمون‌ها</a>
      </li>
    </ul>

    <div class="tab-content" id="mainTabsContent">
      <!-- داشبورد -->
      <div class="tab-pane fade show active" id="dashboard" role="tabpanel">
        <?php
          try {
            $mainCount = $pdo->query("SELECT COUNT(*) FROM main_buttons")->fetchColumn();
            $inlineCount = $pdo->query("SELECT COUNT(*) FROM inline_buttons")->fetchColumn();
            $filesCount = $pdo->query("SELECT COUNT(*) FROM files")->fetchColumn();
            $userCount = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
            $suggestedCount = $pdo->query("SELECT COUNT(*) FROM suggested_files")->fetchColumn();
          } catch (PDOException $e) {
            $mainCount = $inlineCount = $filesCount = $userCount = $suggestedCount = 0;
          }
        ?>
        <div class="row mt-3">
          <div class="col-6 col-sm-6 col-md-3 col-lg-2">
            <div class="small-box bg-info">
              <div class="inner">
                <h3><?php echo $mainCount; ?></h3>
                <p>دکمه‌های اصلی</p>
              </div>
              <div class="icon"><i class="fas fa-keyboard"></i></div>
            </div>
          </div>
          <div class="col-6 col-sm-6 col-md-3 col-lg-2">
            <div class="small-box bg-success">
              <div class="inner">
                <h3><?php echo $inlineCount; ?></h3>
                <p>دکمه‌های اینلاین</p>
              </div>
              <div class="icon"><i class="fas fa-keyboard"></i></div>
            </div>
          </div>
          <div class="col-6 col-sm-6 col-md-3 col-lg-2">
            <div class="small-box bg-warning">
              <div class="inner">
                <h3><?php echo $filesCount; ?></h3>
                <p>فایل‌ها</p>
              </div>
              <div class="icon"><i class="fas fa-file-upload"></i></div>
            </div>
          </div>
          <div class="col-6 col-sm-6 col-md-3 col-lg-2">
            <div class="small-box bg-primary">
              <div class="inner">
                <h3><?php echo $userCount; ?></h3>
                <p>کاربران</p>
              </div>
              <div class="icon"><i class="fas fa-users"></i></div>
            </div>
          </div>
          <div class="col-6 col-sm-6 col-md-3 col-lg-2">
            <div class="small-box bg-secondary">
              <div class="inner">
                <h3><?php echo $suggestedCount; ?></h3>
                <p>فایل‌های پیشنهادی</p>
              </div>
              <div class="icon"><i class="fas fa-file-alt"></i></div>
            </div>
          </div>
        </div>
        <!-- نمودار توزیع محتوا -->
        <div class="card mt-3">
          <div class="card-header">
            <h5 class="card-title m-0">توزیع محتوا</h5>
          </div>
          <div class="card-body">
            <canvas id="statsChart" style="height: 300px;"></canvas>
          </div>
        </div>
      </div>

      <!-- افزودن دکمه اصلی -->
      <div class="tab-pane fade" id="addMain" role="tabpanel">
        <h5 class="mt-2 mb-3"><i class="fas fa-plus-circle"></i> افزودن دکمه اصلی</h5>
        <form action="admin_process.php" method="post">
          <input type="hidden" name="action" value="add_main_button">
          <div class="form-group">
            <label>عنوان دکمه (مثلاً: Microsoft Excel):</label>
            <input type="text" name="title" class="form-control" required>
          </div>
          <button type="submit" class="btn btn-success">افزودن دکمه اصلی</button>
        </form>
      </div>

      <!-- افزودن دکمه اینلاین -->
      <div class="tab-pane fade" id="addInline" role="tabpanel">
        <h5 class="mt-2 mb-3"><i class="fas fa-plus-circle"></i> افزودن دکمه اینلاین</h5>
        <form action="admin_process.php" method="post">
          <input type="hidden" name="action" value="add_inline_button">
          <div class="form-group">
            <label>انتخاب دکمه اصلی:</label>
            <select name="main_button_id" class="form-control" required>
              <?php
              try {
                $stmt = $pdo->query("SELECT id, title FROM main_buttons ORDER BY title");
                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    echo "<option value='{$row['id']}'>{$row['title']}</option>";
                }
              } catch (PDOException $e) {
                echo "<option>خطا در دریافت داده‌ها</option>";
              }
              ?>
            </select>
          </div>
          <div class="form-group">
            <label>عنوان دکمه اینلاین (مثلاً: /TRIM):</label>
            <input type="text" name="inline_title" class="form-control" required>
          </div>
          <div class="form-group">
            <label>توضیحات (اختیاری):</label>
            <textarea name="description" class="form-control"></textarea>
          </div>
          <button type="submit" class="btn btn-success">افزودن دکمه اینلاین</button>
        </form>
      </div>

      <!-- آپلود فایل -->
      <div class="tab-pane fade" id="uploadFile" role="tabpanel">
        <h5 class="mt-2 mb-3"><i class="fas fa-upload"></i> آپلود فایل</h5>
        <form action="admin_process.php" method="post" enctype="multipart/form-data">
          <input type="hidden" name="action" value="upload_file">
          <div class="form-group">
            <label>انتخاب دکمه اینلاین:</label>
            <select name="inline_button_id" class="form-control" required>
              <?php
              try {
                $stmt = $pdo->query("SELECT ib.id, ib.title, mb.title AS main_title 
                                     FROM inline_buttons ib INNER JOIN main_buttons mb 
                                     ON ib.main_button_id = mb.id ORDER BY mb.title, ib.title");
                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    echo "<option value='{$row['id']}'>[{$row['main_title']}] - {$row['title']}</option>";
                }
              } catch (PDOException $e) {
                echo "<option>خطا در دریافت داده‌ها</option>";
              }
              ?>
            </select>
          </div>
          <div class="form-group">
            <label>انتخاب فایل:</label>
            <input type="file" name="file" class="form-control-file" required>
          </div>
          <div class="form-group">
            <label>نوع فایل:</label>
            <select name="file_type" class="form-control" required>
              <option value="document">سند</option>
              <option value="video">ویدیو</option>
              <option value="audio">صوت</option>
              <option value="text">متن</option>
            </select>
          </div>
          <div class="form-group">
            <label>کپشن (اختیاری):</label>
            <textarea name="caption" class="form-control"></textarea>
          </div>
          <button type="submit" class="btn btn-success">آپلود فایل</button>
        </form>
      </div>

      <!-- مدیریت دکمه اصلی -->
      <div class="tab-pane fade" id="manageMain" role="tabpanel">
        <h5 class="mt-2 mb-3"><i class="fas fa-edit"></i> مدیریت دکمه‌های اصلی</h5>
        <div class="table-responsive">
          <?php
          try {
            $stmt = $pdo->query("SELECT * FROM main_buttons ORDER BY title");
            echo "<table class='table table-bordered'>";
            echo "<thead><tr><th>ID</th><th>عنوان دکمه</th><th>عملیات</th></tr></thead><tbody>";
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                echo "<tr>
                        <td>{$row['id']}</td>
                        <td>{$row['title']}</td>
                        <td>
                          <button class='btn btn-sm btn-info editMain mr-1' data-id='{$row['id']}' data-title='{$row['title']}'><i class='fas fa-edit'></i> ویرایش</button>
                          <button class='btn btn-sm btn-danger deleteMain' data-id='{$row['id']}'><i class='fas fa-trash-alt'></i> حذف</button>
                        </td>
                      </tr>";
            }
            echo "</tbody></table>";
          } catch (PDOException $e) {
            echo "<div class='alert alert-danger'>خطا در دریافت داده‌ها: " . $e->getMessage() . "</div>";
          }
          ?>
        </div>
      </div>

      <!-- مدیریت دکمه اینلاین -->
      <div class="tab-pane fade" id="manageInline" role="tabpanel">
        <h5 class="mt-2 mb-3"><i class="fas fa-edit"></i> مدیریت دکمه‌های اینلاین</h5>
        <div class="table-responsive">
          <?php
          try {
            $stmt = $pdo->query("SELECT ib.*, mb.title AS main_title FROM inline_buttons ib INNER JOIN main_buttons mb ON ib.main_button_id = mb.id ORDER BY mb.title, ib.title");
            echo "<table class='table table-bordered'>";
            echo "<thead><tr><th>ID</th><th>دکمه اصلی</th><th>عنوان دکمه اینلاین</th><th>توضیحات</th><th>عملیات</th></tr></thead><tbody>";
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                echo "<tr>
                        <td>{$row['id']}</td>
                        <td>{$row['main_title']}</td>
                        <td>{$row['title']}</td>
                        <td>{$row['description']}</td>
                        <td>
                          <button class='btn btn-sm btn-info editInline mr-1' data-id='{$row['id']}' data-title='{$row['title']}' data-description='{$row['description']}'><i class='fas fa-edit'></i> ویرایش</button>
                          <button class='btn btn-sm btn-danger deleteInline' data-id='{$row['id']}'><i class='fas fa-trash-alt'></i> حذف</button>
                        </td>
                      </tr>";
            }
            echo "</tbody></table>";
          } catch (PDOException $e) {
            echo "<div class='alert alert-danger'>خطا در دریافت داده‌ها: " . $e->getMessage() . "</div>";
          }
          ?>
        </div>
      </div>

      <!-- مدیریت فایل‌ها -->
      <div class="tab-pane fade" id="manageFiles" role="tabpanel">
        <h5 class="mt-2 mb-3"><i class="fas fa-edit"></i> مدیریت فایل‌ها</h5>
        <div class="table-responsive">
          <?php
          try {
            $stmt = $pdo->query("SELECT f.*, ib.title AS inline_title, mb.title AS main_title FROM files f INNER JOIN inline_buttons ib ON f.inline_button_id = ib.id INNER JOIN main_buttons mb ON ib.main_button_id = mb.id ORDER BY f.id DESC");
            echo "<table class='table table-bordered'>";
            echo "<thead><tr><th>ID</th><th>دکمه اصلی</th><th>دکمه اینلاین</th><th>نوع فایل</th><th>کپشن</th><th>عملیات</th></tr></thead><tbody>";
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                echo "<tr>
                        <td>{$row['id']}</td>
                        <td>{$row['main_title']}</td>
                        <td>{$row['inline_title']}</td>
                        <td>{$row['file_type']}</td>
                        <td>{$row['caption']}</td>
                        <td>
                          <button class='btn btn-sm btn-info editFile mr-1' data-id='{$row['id']}' data-caption='{$row['caption']}'><i class='fas fa-edit'></i> ویرایش</button>
                          <button class='btn btn-sm btn-danger deleteFile' data-id='{$row['id']}'><i class='fas fa-trash-alt'></i> حذف</button>
                        </td>
                      </tr>";
            }
            echo "</tbody></table>";
          } catch (PDOException $e) {
            echo "<div class='alert alert-danger'>خطا در دریافت داده‌ها: " . $e->getMessage() . "</div>";
          }
          ?>
        </div>
      </div>

      <!-- مدیریت کاربران -->
      <div class="tab-pane fade" id="userManagement" role="tabpanel">
        <h5 class="mt-2 mb-3"><i class="fas fa-users"></i> مدیریت کاربران</h5>
        <div class="table-responsive">
          <?php
          try {
            $stmt = $pdo->query("SELECT * FROM users ORDER BY start_time DESC");
            echo "<table class='table table-bordered'>";
            echo "<thead><tr>
                    <th>ID</th>
                    <th>تلگرام آی‌دی</th>
                    <th>نام کاربری</th>
                    <th>نام کامل</th>
                    <th>تاریخ استارت</th>
                    <th>آخرین استفاده</th>
                    <th>وضعیت</th>
                    <th>عملیات</th>
                  </tr></thead><tbody>";
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $username = !empty($row['username']) ? $row['username'] : "-";
                $fullName = !empty($row['full_name']) ? $row['full_name'] : "-";
                $status = ($row['status'] == 'blocked') ? "<span class='badge badge-danger'>بلاک شده</span>" : "<span class='badge badge-success'>فعال</span>";
                $actionBtn = ($row['status'] == 'blocked') 
                           ? "<button class='btn btn-sm btn-success toggleUser mr-1' data-id='{$row['id']}' data-action='unblock'><i class='fas fa-unlock-alt'></i> آن‌بلاک</button>"
                           : "<button class='btn btn-sm btn-warning toggleUser' data-id='{$row['id']}' data-action='block'><i class='fas fa-lock'></i> بلاک</button>";
                echo "<tr>
                        <td>{$row['id']}</td>
                        <td>{$row['telegram_id']}</td>
                        <td>{$username}</td>
                        <td>{$fullName}</td>
                        <td>{$row['start_time']}</td>
                        <td>{$row['last_usage']}</td>
                        <td>{$status}</td>
                        <td>{$actionBtn}</td>
                      </tr>";
            }
            echo "</tbody></table>";
          } catch (PDOException $e) {
            echo "<div class='alert alert-danger'>خطا در دریافت داده‌ها: " . $e->getMessage() . "</div>";
          }
          ?>
        </div>
      </div>

      <!-- فایل‌های پیشنهادی -->
      <div class="tab-pane fade" id="suggestedFiles" role="tabpanel">
        <h5 class="mt-2 mb-3"><i class="fas fa-file-alt"></i> فایل‌های پیشنهادی</h5>
        <div class="table-responsive">
          <?php
          try {
            $stmt = $pdo->query("SELECT sf.*, u.telegram_id, u.username, u.full_name 
                                 FROM suggested_files sf 
                                 LEFT JOIN users u ON sf.user_id = u.id 
                                 ORDER BY sf.submission_time DESC");
            echo "<table class='table table-bordered'>";
            echo "<thead><tr>
                    <th>ID</th>
                    <th>تلگرام آی‌دی</th>
                    <th>نام کاربری</th>
                    <th>نام کامل</th>
                    <th>آیدی فایل</th>
                    <th>زمان ارسال</th>
                    <th>وضعیت</th>
                    <th>عملیات</th>
                  </tr></thead><tbody>";
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $username = !empty($row['username']) ? $row['username'] : "-";
                $fullName = !empty($row['full_name']) ? $row['full_name'] : "-";
                if ($row['status'] == 'approved') {
                    $status = "<span class='badge badge-success'>تایید شده</span>";
                } elseif ($row['status'] == 'rejected') {
                    $status = "<span class='badge badge-danger'>رد شده</span>";
                } else {
                    $status = "<span class='badge badge-warning'>در انتظار</span>";
                }
                // کوتاه کردن آیدی فایل در صورت طولانی بودن
                $fileIdShort = (mb_strlen($row['file_url']) > 20) ? mb_substr($row['file_url'], 0, 20) . '...' : $row['file_url'];
                $ops  = "<button class='btn btn-sm btn-primary mr-1' onclick=\"window.open('view_file.php?file_id=" . urlencode($row['file_url']) . "', '_blank')\"><i class='fas fa-eye'></i> مشاهده</button>";
                $ops .= "<button class='btn btn-sm btn-success mr-1 approveFile' data-id='{$row['id']}'><i class='fas fa-check'></i> تایید</button>";
                $ops .= "<button class='btn btn-sm btn-danger rejectFile' data-id='{$row['id']}'><i class='fas fa-times'></i> رد</button>";
                echo "<tr>
                        <td>{$row['id']}</td>
                        <td>{$row['telegram_id']}</td>
                        <td>{$username}</td>
                        <td>{$fullName}</td>
                        <td>{$fileIdShort}</td>
                        <td>{$row['submission_time']}</td>
                        <td>{$status}</td>
                        <td>{$ops}</td>
                      </tr>";
            }
            echo "</tbody></table>";
          } catch (PDOException $e) {
            echo "<div class='alert alert-danger'>خطا در دریافت داده‌ها: " . $e->getMessage() . "</div>";
          }
          ?>
        </div>
      </div>

      <!-- مدیریت آزمون‌ها -->
      <div class="tab-pane fade" id="manageExams" role="tabpanel">
        <h5 class="mt-2 mb-3"><i class="fas fa-edit"></i> مدیریت آزمون‌ها</h5>
        
        <!-- فرم افزودن آزمون جدید -->
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h6 class="m-0"><i class="fas fa-plus-circle"></i> افزودن آزمون جدید</h6>
            </div>
            <div class="card-body">
                <form method="post" action="admin_process.php">
                    <input type="hidden" name="action" value="add_exam">
                    
                    <div class="form-group">
                        <label>عنوان آزمون:</label>
                        <input type="text" name="title" class="form-control" required>
                    </div>
                    
                    <div class="form-group">
                        <label>توضیحات آزمون:</label>
                        <textarea name="description" class="form-control" rows="3"></textarea>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>زمان شروع:</label>
                            <input type="datetime-local" name="start_time" class="form-control" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label>زمان پایان:</label>
                            <input type="datetime-local" name="end_time" class="form-control" required>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> ذخیره آزمون</button>
                </form>
            </div>
        </div>
        
        <!-- جدول آزمون‌ها -->
        <div class="card">
            <div class="card-header bg-info text-white">
                <h6 class="m-0"><i class="fas fa-list"></i> لیست آزمون‌های موجود</h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>شناسه</th>
                                <th>عنوان</th>
                                <th>زمان شروع</th>
                                <th>زمان پایان</th>
                                <th>وضعیت</th>
                                <th>تعداد سوالات</th>
                                <th>عملیات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            // دریافت لیست آزمون‌ها
                            $exams_query = $pdo->query("SELECT e.*, 
                                                         (SELECT COUNT(*) FROM questions WHERE exam_id = e.id) as question_count 
                                                         FROM exams e ORDER BY e.start_time DESC");
                            
                            if ($exams_query->rowCount() > 0) {
                                while ($exam = $exams_query->fetch(PDO::FETCH_ASSOC)) {
                                    $now = new DateTime();
                                    $start = new DateTime($exam['start_time']);
                                    $end = new DateTime($exam['end_time']);
                                    
                                    if ($now < $start) {
                                        $status = '<span class="badge badge-warning">منتظر شروع</span>';
                                    } elseif ($now > $end) {
                                        $status = '<span class="badge badge-secondary">پایان یافته</span>';
                                    } else {
                                        $status = '<span class="badge badge-success">در حال اجرا</span>';
                                    }
                                    
                                    echo "<tr>
                                            <td>{$exam['id']}</td>
                                            <td>{$exam['title']}</td>
                                            <td>" . date('Y/m/d H:i', strtotime($exam['start_time'])) . "</td>
                                            <td>" . date('Y/m/d H:i', strtotime($exam['end_time'])) . "</td>
                                            <td>$status</td>
                                            <td>{$exam['question_count']}</td>
                                            <td>
                                                <div class='btn-group btn-group-sm'>
                                                    <a href='admin.php?tab=exams&exam_id={$exam['id']}' class='btn btn-info' title='مدیریت سوالات'><i class='fas fa-question-circle'></i></a>
                                                    <a href='admin_process.php?action=edit_exam&id={$exam['id']}' class='btn btn-primary' title='ویرایش آزمون'><i class='fas fa-edit'></i></a>
                                                    <button type='button' class='btn btn-success' title='مشاهده لینک آزمون' onclick='showExamLink({$exam['id']})'><i class='fas fa-link'></i></button>
                                                    <a href='admin_process.php?action=delete_exam&id={$exam['id']}' class='btn btn-danger' onclick='return confirm(\"آیا از حذف این آزمون اطمینان دارید؟\");' title='حذف آزمون'><i class='fas fa-trash'></i></a>
                                                    <a href='admin_process.php?action=duplicate_exam&id={$exam['id']}' class='btn btn-secondary' title='کپی آزمون'><i class='fas fa-copy'></i></a>
                                                    <a href='admin_process.php?action=export_results&exam_id={$exam['id']}' class='btn btn-success' title='دانلود نتایج'><i class='fas fa-download'></i></a>
                                                </div>
                                            </td>
                                          </tr>";
                                }
                            } else {
                                echo "<tr><td colspan='7' class='text-center'>هیچ آزمونی یافت نشد</td></tr>";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        
        <?php if (isset($_GET['exam_id']) && $_GET['tab'] == 'exams'): ?>
        <!-- مدیریت سوالات آزمون -->
        <div class="card mt-4">
            <?php
            // دریافت اطلاعات آزمون
            $exam_id = intval($_GET['exam_id']);
            $exam_query = $pdo->prepare("SELECT * FROM exams WHERE id = :id");
            $exam_query->execute([':id' => $exam_id]);
            $exam = $exam_query->fetch(PDO::FETCH_ASSOC);
            
            if ($exam):
            ?>
            <div class="card-header bg-primary text-white">
                <h6 class="m-0"><i class="fas fa-question-circle"></i> مدیریت سوالات آزمون: <?php echo $exam['title']; ?></h6>
            </div>
            <div class="card-body">
                <!-- فرم افزودن سوال -->
                <div class="mb-4">
                    <h6>افزودن سوال جدید</h6>
                    <form method="post" action="admin_process.php">
                        <input type="hidden" name="action" value="add_question">
                        <input type="hidden" name="exam_id" value="<?php echo $exam_id; ?>">
                        
                        <div class="form-group">
                            <label>متن سوال:</label>
                            <textarea name="question_text" class="form-control" required></textarea>
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label>نوع سوال:</label>
                                <select name="question_type" class="form-control" id="question_type">
                                    <option value="multiple">چند گزینه‌ای</option>
                                    <option value="descriptive">تشریحی</option>
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label>نمره:</label>
                                <input type="number" name="score" class="form-control" value="1" min="0" max="100">
                            </div>
                        </div>
                        
                        <div id="options_section">
                            <div class="form-row mb-2">
                                <div class="col-md-10">
                                    <input type="text" name="options[1][text]" class="form-control" placeholder="گزینه 1">
                                </div>
                                <div class="col-md-2">
                                    <div class="custom-control custom-checkbox mt-2">
                                        <input type="checkbox" name="options[1][is_correct]" value="1" class="custom-control-input" id="option1_correct">
                                        <label class="custom-control-label" for="option1_correct">صحیح</label>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row mb-2">
                                <div class="col-md-10">
                                    <input type="text" name="options[2][text]" class="form-control" placeholder="گزینه 2">
                                </div>
                                <div class="col-md-2">
                                    <div class="custom-control custom-checkbox mt-2">
                                        <input type="checkbox" name="options[2][is_correct]" value="1" class="custom-control-input" id="option2_correct">
                                        <label class="custom-control-label" for="option2_correct">صحیح</label>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row mb-2">
                                <div class="col-md-10">
                                    <input type="text" name="options[3][text]" class="form-control" placeholder="گزینه 3">
                                </div>
                                <div class="col-md-2">
                                    <div class="custom-control custom-checkbox mt-2">
                                        <input type="checkbox" name="options[3][is_correct]" value="1" class="custom-control-input" id="option3_correct">
                                        <label class="custom-control-label" for="option3_correct">صحیح</label>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row mb-2">
                                <div class="col-md-10">
                                    <input type="text" name="options[4][text]" class="form-control" placeholder="گزینه 4">
                                </div>
                                <div class="col-md-2">
                                    <div class="custom-control custom-checkbox mt-2">
                                        <input type="checkbox" name="options[4][is_correct]" value="1" class="custom-control-input" id="option4_correct">
                                        <label class="custom-control-label" for="option4_correct">صحیح</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> ذخیره سوال</button>
                    </form>
                </div>
                
                <!-- لیست سوالات موجود -->
                <hr>
                <h6>سوالات موجود</h6>
                <?php
                $questions_query = $pdo->prepare("SELECT * FROM questions WHERE exam_id = :exam_id ORDER BY id");
                $questions_query->execute([':exam_id' => $exam_id]);
                
                if ($questions_query->rowCount() > 0):
                    $i = 1;
                    while ($question = $questions_query->fetch(PDO::FETCH_ASSOC)):
                ?>
                <div class="card mb-3">
                    <div class="card-header bg-light">
                        <div class="d-flex justify-content-between">
                            <h6>سوال <?php echo $i++; ?> (<?php echo $question['score']; ?> نمره)</h6>
                            <div>
                                <a href="admin_process.php?action=edit_question&id=<?php echo $question['id']; ?>" class="btn btn-sm btn-primary"><i class="fas fa-edit"></i></a>
                                <a href="admin_process.php?action=delete_question&id=<?php echo $question['id']; ?>&exam_id=<?php echo $exam_id; ?>" class="btn btn-sm btn-danger" onclick="return confirm('آیا از حذف این سوال اطمینان دارید؟');"><i class="fas fa-trash"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <p class="card-text"><?php echo $question['question_text']; ?></p>
                        
                        <?php if ($question['question_type'] == 'multiple'): 
                            // دریافت گزینه‌های سوال
                            $options_query = $pdo->prepare("SELECT * FROM options WHERE question_id = :question_id ORDER BY id");
                            $options_query->execute([':question_id' => $question['id']]);
                            $options = $options_query->fetchAll(PDO::FETCH_ASSOC);
                        ?>
                        <div class="list-group">
                            <?php foreach($options as $option): ?>
                            <div class="list-group-item <?php echo $option['is_correct'] ? 'list-group-item-success' : ''; ?>">
                                <?php echo $option['option_text']; ?>
                                <?php if($option['is_correct']): ?>
                                    <span class="badge badge-success ml-1"><i class="fas fa-check"></i> گزینه صحیح</span>
                                <?php endif; ?>
                            </div>
                            <?php endforeach; ?>
                        </div>
                        <?php else: ?>
                        <div class="alert alert-info">
                            <i class="fas fa-pencil-alt"></i> سوال تشریحی
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php 
                    endwhile;
                else:
                ?>
                <div class="alert alert-warning">هیچ سوالی برای این آزمون تعریف نشده است.</div>
                <?php endif; ?>
            </div>
            <?php else: ?>
            <div class="card-body">
                <div class="alert alert-danger">آزمون مورد نظر یافت نشد.</div>
            </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>
      </div>
      
      <script>
        // اسکریپت مدیریت نمایش بخش گزینه‌ها برای سوال تشریحی و چندگزینه‌ای
        $(document).ready(function() {
            $('#question_type').change(function() {
                if ($(this).val() == 'descriptive') {
                    $('#options_section').hide();
                } else {
                    $('#options_section').show();
                }
            });
        });
      </script>
    </div>
  </div>

  <!-- مدال‌های ویرایش -->
  <!-- مدال ویرایش دکمه اصلی -->
  <div class="modal fade" id="editMainModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
      <form id="editMainForm" action="admin_process.php" method="post">
        <input type="hidden" name="action" value="edit_main_button">
        <input type="hidden" name="id" id="editMainId">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">ویرایش دکمه اصلی</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="بستن">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="form-group">
              <label>عنوان دکمه:</label>
              <input type="text" name="title" id="editMainTitle" class="form-control" required>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">انصراف</button>
            <button type="submit" class="btn btn-primary">ذخیره تغییرات</button>
          </div>
        </div>
      </form>
    </div>
  </div>

  <!-- مدال ویرایش دکمه اینلاین -->
  <div class="modal fade" id="editInlineModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
      <form id="editInlineForm" action="admin_process.php" method="post">
        <input type="hidden" name="action" value="edit_inline_button">
        <input type="hidden" name="id" id="editInlineId">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">ویرایش دکمه اینلاین</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="بستن">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="form-group">
              <label>عنوان دکمه اینلاین:</label>
              <input type="text" name="inline_title" id="editInlineTitle" class="form-control" required>
            </div>
            <div class="form-group">
              <label>توضیحات:</label>
              <textarea name="description" id="editInlineDescription" class="form-control"></textarea>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">انصراف</button>
            <button type="submit" class="btn btn-primary">ذخیره تغییرات</button>
          </div>
        </div>
      </form>
    </div>
  </div>

  <!-- مدال ویرایش فایل -->
  <div class="modal fade" id="editFileModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
      <form id="editFileForm" action="admin_process.php" method="post">
        <input type="hidden" name="action" value="edit_file">
        <input type="hidden" name="id" id="editFileId">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">ویرایش فایل</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="بستن">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="form-group">
              <label>کپشن:</label>
              <textarea name="caption" id="editFileCaption" class="form-control"></textarea>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">انصراف</button>
            <button type="submit" class="btn btn-primary">ذخیره تغییرات</button>
          </div>
        </div>
      </form>
    </div>
  </div>

  <!-- مودال نمایش لینک آزمون -->
  <div class="modal fade" id="examLinkModal" tabindex="-1" role="dialog" aria-labelledby="examLinkModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header bg-primary text-white">
          <h5 class="modal-title" id="examLinkModalLabel">لینک آزمون</h5>
          <button type="button" class="close ml-0 mr-auto text-white" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <p>این لینک را به کاربران ارسال کنید تا بتوانند در آزمون شرکت کنند:</p>
          <div class="input-group mb-3">
            <input type="text" id="examLinkInput" class="form-control" readonly>
            <div class="input-group-append">
              <button class="btn btn-primary" type="button" onclick="copyExamLink()">کپی لینک</button>
            </div>
          </div>
          <div id="copyMessage" class="alert alert-success d-none">لینک کپی شد!</div>
          <hr>
          <p>برای مشاهده این لینک در ربات، کاربران باید ابتدا آزمون را از طریق ربات انتخاب کنند.</p>
          <p><strong>راهنمای ارسال به کاربران:</strong></p>
          <ol>
            <li>کاربر باید در ربات تلگرام به بخش آزمون‌ها مراجعه کند.</li>
            <li>پس از انتخاب آزمون، گزینه "شروع آزمون در وب" را انتخاب کند.</li>
            <li>یا مستقیماً از طریق لینک بالا وارد آزمون شود.</li>
          </ol>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">بستن</button>
        </div>
      </div>
    </div>
  </div>
</div> <!-- پایان Wrapper -->

<!-- اسکریپت‌های مورد نیاز -->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
  setTimeout(function(){
    $('.flash-message').fadeOut('slow');
  }, 4000);

  $('.editMain').click(function(){
    var id = $(this).data('id');
    var title = $(this).data('title');
    $('#editMainId').val(id);
    $('#editMainTitle').val(title);
    $('#editMainModal').modal('show');
  });

  $('.editInline').click(function(){
    var id = $(this).data('id');
    var title = $(this).data('title');
    var description = $(this).data('description');
    $('#editInlineId').val(id);
    $('#editInlineTitle').val(title);
    $('#editInlineDescription').val(description);
    $('#editInlineModal').modal('show');
  });

  $('.editFile').click(function(){
    var id = $(this).data('id');
    var caption = $(this).data('caption');
    $('#editFileId').val(id);
    $('#editFileCaption').val(caption);
    $('#editFileModal').modal('show');
  });

  $('.deleteMain').click(function(){
    if(confirm("آیا از حذف این دکمه اصلی مطمئن هستید؟")){
      var id = $(this).data('id');
      window.location.href = "admin_process.php?action=delete_main_button&id=" + id;
    }
  });

  $('.deleteInline').click(function(){
    if(confirm("آیا از حذف این دکمه اینلاین مطمئن هستید؟")){
      var id = $(this).data('id');
      window.location.href = "admin_process.php?action=delete_inline_button&id=" + id;
    }
  });

  $('.deleteFile').click(function(){
    if(confirm("آیا از حذف این فایل مطمئن هستید؟")){
      var id = $(this).data('id');
      window.location.href = "admin_process.php?action=delete_file&id=" + id;
    }
  });

  $('.toggleUser').click(function(){
    var id = $(this).data('id');
    var action = $(this).data('action');
    window.location.href = "admin_process.php?action=toggle_user&id=" + id + "&toggle=" + action;
  });

  $('.approveFile').click(function(){
    var id = $(this).data('id');
    window.location.href = "admin_process.php?action=approve_suggested&id=" + id;
  });
  $('.rejectFile').click(function(){
    var id = $(this).data('id');
    window.location.href = "admin_process.php?action=reject_suggested&id=" + id;
  });

  var ctx = document.getElementById('statsChart').getContext('2d');
  var statsChart = new Chart(ctx, {
    type: 'bar',
    data: {
      labels: ['دکمه اصلی', 'دکمه اینلاین', 'فایل‌ها', 'کاربران', 'فایل‌های پیشنهادی'],
      datasets: [{
        label: 'تعداد',
        data: [
          <?php echo $mainCount; ?>, 
          <?php echo $inlineCount; ?>, 
          <?php echo $filesCount; ?>, 
          <?php echo $userCount; ?>, 
          <?php echo $suggestedCount; ?>
        ],
        backgroundColor: [
          '#17a2b8', 
          '#28a745', 
          '#ffc107', 
          '#007bff', 
          '#6c757d'
        ]
      }]
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      scales: {
        yAxes: [{
          ticks: { beginAtZero: true, precision: 0 }
        }]
      },
      animation: { duration: 1500 }
    }
  });

  // تابع نمایش لینک آزمون
  function showExamLink(examId) {
    // ساخت لینک آزمون برای نمایش
    const baseUrl = window.location.origin + window.location.pathname.replace('admin.php', '');
    // ایجاد یک لینک آزمون دمو (واقعی توسط exam_functions.php تولید می‌شود)
    const demoLink = baseUrl + 'exam.php?exam_id=' + examId + '&demo=1';
    
    // نمایش لینک در مودال
    document.getElementById('examLinkInput').value = demoLink;
    $('#examLinkModal').modal('show');
    
    // پنهان کردن پیام کپی
    document.getElementById('copyMessage').classList.add('d-none');
    
    // همچنین یک درخواست AJAX برای دریافت لینک‌های واقعی آزمون می‌توان ارسال کرد
    // اما برای نمایش فعلاً از لینک دمو استفاده می‌کنیم
  }
  
  // تابع کپی لینک آزمون
  function copyExamLink() {
    const copyText = document.getElementById('examLinkInput');
    copyText.select();
    document.execCommand('copy');
    
    // نمایش پیام کپی
    document.getElementById('copyMessage').classList.remove('d-none');
    
    // پنهان کردن پیام پس از 3 ثانیه
    setTimeout(function() {
      document.getElementById('copyMessage').classList.add('d-none');
    }, 3000);
  }
</script>
</body>
</html>
